function fault_slip_plot_diag_history(colors,Delta_p_max,Delta_p_min,Delta_p_plot,...
    Delta_y_plot,Delta_y_target,flag_plot_cap,p_max_bounds,p_min_bounds,p_plot,p_seismic)
%
% Plots diagnostics to check pressure stepping algorithm: Delta_p and Delta_y as function of
% depletion pressure.  

% Retrieve colors:
green = colors(3,:);

figure
% Delta p history:
subplot(2,1,1) 
plot(-p_plot/1e6,-Delta_p_plot/1e6,'-o','Color','r','MarkerEdgeColor','r','LineWidth',1.5,...
    'MarkerSize',4);
hold on
plot(-p_plot(end)/1e6,-Delta_p_plot(end)/1e6,'^','MarkerEdgeColor',green,'MarkerFaceColor',...
    green,'LineWidth',1.5);
line([-p_max_bounds/1e6 -p_min_bounds/1e6],[-Delta_p_max/1e6 -Delta_p_max/1e6],...
    'LineStyle','--','Color','k','LineWidth',1)
line([-p_max_bounds/1e6 -p_min_bounds/1e6],[-Delta_p_min/1e6 -Delta_p_min/1e6],...
    'LineStyle','--','Color','k','LineWidth',1)
hold off
p_min_bounds_plot = max(floor(1.02 * p_seismic/1e6)*1e6,p_min_bounds);
axis([-p_max_bounds/1e6 -p_min_bounds_plot/1e6 0 inf])
xlabel('$\it -p$ (MPa)','Interpreter','latex','FontSize',11)
ylabel('$\it -\Delta\ p$ (MPa)','Interpreter','latex','FontSize',11)
if flag_plot_cap == 1
    [t,s] = title('plot\_diag\_history',' '); % first line: plot file locator
    t.Color = 'r';
    t.FontSize = 10;
    s.FontSize = 10;
    t.FontWeight = 'normal';
    s.FontWeight = 'normal';
end

% Delta y history:
subplot(2,1,2)
plot(-p_plot/1e6,Delta_y_plot,'-o','Color','r','MarkerEdgeColor','r','LineWidth',1.5,...
    'MarkerSize',4);
hold on
plot(-p_plot(end)/1e6,Delta_y_plot(end),'^','MarkerEdgeColor',green,'MarkerFaceColor',green,...
    'LineWidth',1.5);
line([-p_max_bounds/1e6 -p_min_bounds/1e6],[Delta_y_target Delta_y_target],...
    'LineStyle','--','Color','k','LineWidth',1)
hold off
axis([-p_max_bounds/1e6 -p_min_bounds_plot/1e6 0 inf])
xlabel('$\it -p$ (MPa)','Interpreter','latex','FontSize',11)
ylabel('$\Delta{\it y}$ (m)','Interpreter','latex','FontSize',11)
